UNIT Globals;
INTERFACE
USES
{$L-}
{$U-}
     {$LOAD MQOTP.dumpfile}
       Memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf {$LOAD};
{$U+}
{$SETC DebugFlg:=FALSE}
CONST
  NumWords = 128;
  GoodEvent = MDownMask;

  SubjectA = 1;
  VerbA	   = 2;
  ObjectA1 = 3;
  ObjectA2 = 4;
  SubjectB = 5;
  VerbB	   = 6;
  ObjectB1 = 7;
  ObjectB2 = 8;
  
  Dawn = 480;    {8:00 AM}
  Sunset = 1200; {8:00 PM}
  Night = 1260;  {9:00 PM}
  
  BegDelay = 180;
  IntDelay = 90;
  ExpDelay = 0;

  SntcLeng = 8;
  HistLeng = 1000;
  TransLeng = 80;
  DlogMax  = 25;
  MaxEvents = 4096;

  HowDepart = 1;
  HowArrive = 2;
  
  ScrnX1 = 84; 
  ScrnX2 = 230;
  ScrnY1 = 20;
  ScrnY2 = 178;
  ConstChars = 7;

  WNobody 	= 10;
  WWho	  	= 11;
  WGreet   	= 25;
  WGoodbye 	= 26;
  WWarm    	= 27;
  WNice    	= 28;
  WSincere 	= 29;
  WCool		= 30;
  WThreaten = 31;
  WHaughty 	= 32;
  WFormal  	= 33;
  WAccuse 	= 34;
  WReveal 	= 44;
  WBeg    	= 45;
  WThreat 	= 46;
  WBetray 	= 47;
  WGo	  	= 49;
  WTell	  	= 73;
  WAgree  	= 74;
  WReject 	= 75;
  WIf	  	= 76;
  WAsk	  	= 77;
  WAnswer 	= 78;
  WThat	  	= 82;
  WNBetray  = 83;
  WNAttack  = 84;
  WWait   	= 86;
  WBBetray  = 90;
  WBAttack  = 91;
  WPause  	= 102;
  WSayFeel 	= 113;
  WSTalk   	= 114;
  WFlatter 	= 115;
  WTrust 	= 116;
  WFear		= 117;
  WLove		= 118;
  WNFear	= 119;
  WNTrust	= 120;
  WNLove	= 121;
  WForgive 	= 122;
  WAnger   	= 123;
  WThanks  	= 125;
  WApolgz  	= 126;
  WDeride  	= 127;

TYPE
  {IconHolder = ARRAY[1..64] OF Integer;}
  DatesType = ARRAY[1..HistLeng] OF Integer;
  DatesPtr = ^DatesType;
  DatesHndl = ^DatesPtr;
  WhoKnowT = ARRAY[1..HistLeng] OF PACKED ARRAY[1..8] OF Boolean;
  WhoKnowP = ^WhoKnowT;
  WhoKnowH = ^WhoKnowP;

  TransRecord = RECORD
                  Square: Rect;
                  IconID: Integer;
                END;
  DumbArray = ARRAY[0..33] OF Integer;
  IditArr = ARRAY[0..3200] OF Integer;
  DtArray = ARRAY[0..33] OF LongInt;

VAR
  StartDummy:	Integer;
  MyPort:  		GrafPort;
  SmalWind:		WindowPtr;
  WhichWindow:	WindowPtr;
  WhichContrl:	ControlHandle;
  ERecord:  	WindowRecord;
  MenuArr:  	ARRAY[1..8] OF MenuHandle;
  MyEvent:  	EventRecord;
  StdRect1: 	Rect;
  StdRect2: 	Rect;
  StdRect3:		Rect;
  StdRect4:		Rect;
  QuitFlag: 	Boolean;
  MousePt:  	Point;
  SntcIndx: 	Integer;
  CurWord:  	Integer;
  Sentence: 	ARRAY[0..ConstChars] OF ARRAY[1..SntcLeng] OF Integer;
  LastSntc: 	ARRAY[1..ConstChars] OF ARRAY[1..SntcLeng] OF Integer;
  IconID:   	ARRAY[1..24] OF Integer;
  IconCount:	Integer;
  DummyF1:  	Integer;
  Follows1: 	ARRAY[1..NumWords] OF PACKED ARRAY[0..NumWords] OF Boolean;
  Follows2: 	ARRAY[1..NumWords] OF PACKED ARRAY[0..NumWords] OF Boolean;
  DummyF2:  	Integer;
  SoundOn:  	Boolean;
  StoryDelay:	Integer;
  WordPosX: 	ARRAY[1..SntcLeng] OF Integer;
  WordPosY: 	ARRAY[1..SntcLeng] OF Integer;
  DealPosX: 	ARRAY[1..11] OF Integer;
  DealPosY: 	ARRAY[1..11] OF Integer;
  CharLocn: 	ARRAY[0..ConstChars] OF Integer;
  Love:			ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  Trust:    	ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  Fear:   		ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  Loyalty:		ARRAY[1..ConstChars] OF Integer;
  Integrity:	ARRAY[1..ConstChars] OF Integer;
  Temper:		ARRAY[1..ConstChars] OF Integer;
  Revenge:		ARRAY[1..ConstChars] OF Integer;
  Duty:			ARRAY[1..ConstChars] OF Integer;
  Pride:		ARRAY[1..ConstChars] OF Integer;
  Secret:		ARRAY[1..ConstChars] OF Integer;
  DesLiked:		ARRAY[1..ConstChars] OF Integer;
  Gullble:		ARRAY[1..ConstChars] OF Integer;
  CanclAble:	ARRAY[1..SntcLeng] OF Boolean;
  Day,Time: 	Integer;
  HistIndx: 	Integer;
  Player:		Integer;
  AuraCnt:		ARRAY[1..3] OF ARRAY[1..ConstChars] OF ARRAY[0..ConstChars] OF Integer;
  ExecTime:		ARRAY[1..ConstChars] OF Integer;
  DoItRect:		Rect;
  CnclRect:		Rect;
  BkSpRect:		Rect;
  OKRect:		Rect;
  TransList:	ARRAY[1..TransLeng] OF TransRecord;
  TransIndx:	Integer;
  HstDateH:		DatesHndl;
  HstTimeH:		DatesHndl;
  HstWrd1H:		DatesHndl;
  HstWrd3H:		DatesHndl;
  HstKnowH:		ARRAY[1..HistLeng] OF PACKED ARRAY[1..8] OF Boolean;
  NarratOn:		Boolean;
  CharName:		ARRAY[1..8] OF String[16];
  Male:			ARRAY[1..ConstChars] OF Boolean;
  Species:		ARRAY[1..ConstChars] OF String[16];
  DoorLock:		ARRAY[1..ConstChars] OF Boolean;
  Interloc:		ARRAY[1..ConstChars] OF Integer;
  DlogHist:		ARRAY[1..ConstChars] OF ARRAY[1..DlogMax] OF ARRAY[1..SntcLeng] OF Integer;
  DlogIndx:		ARRAY[1..ConstChars] OF Integer;
  WordRect:		Rect;
  RoomRect:		Rect;
  PlayRect:		Rect;
  ComdRect:		Rect;
  StatRect: 	Rect;
  FeelRect:		Rect;
  DiurnalP:		Pattern;
  StoryParm:	ARRAY[1..99] OF Integer;
  Level:		Integer;
  NumChars:		Integer;
  GameLeng:		Integer;
  GuestFlg:		ARRAY[1..ConstChars] OF Boolean;
  HelloFlg:		ARRAY[1..ConstChars] OF Boolean;
  LoveMood:		ARRAY[1..ConstChars] OF Integer;
  TrstMood:		ARRAY[1..ConstChars] OF Integer;
  FearMood:		ARRAY[1..ConstChars] OF Integer;
  Me:			Integer;
  Him:			Integer;
  FoundPlan:	Boolean;
  Aslyn:		Integer;
  Fiance:		ARRAY[1..8] OF String[16];
  FBetrayals:	Integer;
  PlayerDeals:	Integer;
  DlogCount:	Integer;
  ThatGuy:		Integer;
  LastLove:		Integer;
  LastTrust:	Integer;
  LastFear:		Integer;
  BarGraphFlag:	Boolean;
  BarGraphRect:	ARRAY[1..6] OF Rect;
  BarGraphLabl:	ARRAY[1..6] OF String[24];
  FaceRect:		Rect;
  SavedFace:	Integer;
  NBetray:		ARRAY[1..7] OF ARRAY[1..7] OF PACKED ARRAY[1..64] OF Boolean;
  NAttack:		ARRAY[1..7] OF ARRAY[1..7] OF Boolean;
  NBetrayCount:	ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  NAttackCount:	ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  Beneficence:	ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  MaxPers:		Integer;
  Desperation:	Integer;
  Visits:		ARRAY[1..ConstChars] OF ARRAY[1..ConstChars] OF Integer;
  InfoRecord:	AppFile;
  {$IFC DebugFlg}
  Debug1:		ARRAY[1..ConstChars] OF Integer;
  Debug2:		ARRAY[1..ConstChars] OF Integer;
  Debug3:		ARRAY[1..ConstChars] OF Integer;
  Debug4:		ARRAY[1..ConstChars] OF Integer;
  DebugVal:		ARRAY[1..NumWords] OF Integer;
  DealCount:	Integer;
  DealTemp:		ARRAY[1..16] OF Integer;
  DealDesp:		ARRAY[1..16] OF Integer;
  DealTrst:		ARRAY[1..16] OF Integer;
  DealOblg:		ARRAY[1..16] OF Integer;
  DealTrMd:		ARRAY[1..16] OF Integer;
  DealLove:		ARRAY[1..16] OF Integer;
  {$ENDC}
  EndDummy:	   Integer;
  WordIcon:		ARRAY[1..NumWords] OF BitMap;
  WordText: 	ARRAY[1..NumWords] OF BitMap;
  CombatHndl:	Handle;
  CombatPtr:	Ptr;
  CbFFPtr:		FFSynthPtr;
  Face:			ARRAY[1..8] OF BitMap;
  Emotion:		ARRAY[1..42] OF BitMap;

PROCEDURE MyWait(DelayInt: Integer);
PROCEDURE ClearRect(Left,Top,Right,Bottom: Integer);
FUNCTION  SpinWheel(DelayInt: Integer): Boolean;
PROCEDURE MyWrite(Mantissa: Integer);
PROCEDURE Narrate(Message,WordNum: Integer);
PROCEDURE CleanOutRect(CleanRect: Rect);
PROCEDURE RightCnct(WhereX,WhereY: Integer);
PROCEDURE DownCnct(WhereX,WhereY: Integer);
PROCEDURE PlotWord(PWord,PlotX,PlotY:  Integer);
PROCEDURE PlotSntc(Who,WhereX,WhereY: Integer; EndConnect: Boolean);
PROCEDURE DrawClock(x,y,DDate,DTime: Integer);
PROCEDURE GrayRect(ThisRect: Rect);
FUNCTION  RectHit(TestRect: Rect): Boolean;
{FUNCTION  MyOpen(FileName: Str255): Integer;}
PROCEDURE StatDisp;
PROCEDURE MakeAFace(Him,WhichFace: Integer);
PROCEDURE MyTranslate;
PROCEDURE WaitForOK;

IMPLEMENTATION
{********************************************************************************}
{$S Chris}
{********************************************************************************}
PROCEDURE MyWait;
VAR DelayT:     LongInt;
BEGIN
  DelayT:=TickCount;
  REPEAT UNTIL (TickCount>=DelayT+DelayInt) OR Button;
END;
{********************************************************************************}
PROCEDURE ClearRect;
VAR  TempRect:  Rect;
BEGIN
  SetRect(TempRect,Left,Top,Right,Bottom);
  FillRect(TempRect,white);
END;
{********************************************************************************}
FUNCTION SpinWheel;
VAR DelayT:     LongInt;
BEGIN
  DelayT:=TickCount;
  REPEAT UNTIL EventAvail(GoodEvent,myEvent) OR (TickCount>DelayT+DelayInt);
  SpinWheel:=EventAvail(GoodEvent,myEvent);
END;
{********************************************************************************}
PROCEDURE MyWrite;
VAR
  LongX:       LongInt;
  NumString:   Str255;
BEGIN
  LongX:=ord4(Mantissa);
  NumToString(LongX,NumString);
  DrawString(NumString);
END;
{********************************************************************************}
PROCEDURE Narrate;
CONST
  name = '&';
  place = '%';
  pronoun = '#';
VAR
  i,x:  Integer;
  LoclRect,FrogRect:	 Rect;
  LoclBits:		 ARRAY[1..1536] OF Integer;
  LoclBMap:		 BitMap;
  TempStrng:	 Str255;
  InsrtStrng:	 Str255;
  SaveStrng:	 Str255;
  RefCon:		 LongInt;
  Insertion:	 Boolean;
  WrapFlag:		 Boolean;
BEGIN
 IF NarratON AND (Message>0) THEN
  BEGIN
  SetRect(LoclRect,64,160,448,224);
  LoclBMap.rowBytes:=48;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  SetRect(FrogRect,68,164,444,220);
  SmalWind:=NewWindow(@ERecord,FrogRect,'A',TRUE,AltDBoxProc,
                              POINTER(-1),TRUE,RefCon);
  SetPort(SmalWind);
  IF Message<=72 THEN GetIndString(TempStrng,301,Message)
  				 ELSE
				   BEGIN
				     TempStrng:='Bad input message';
					 MyWrite(Message);
				   END;

  FOR i:=length(TempStrng) DOWNTO 1 DO
   BEGIN
	 Insertion:=TRUE;
	 CASE TempStrng[i] OF
	  name,place: InsrtStrng:=CharName[WordNum];
	  pronoun: IF Male[WordNum] THEN InsrtStrng:='him' ELSE InsrtStrng:='her';
	  otherwise Insertion:=FALSE;
	 END;
	 IF Insertion THEN
	  BEGIN
	   SaveStrng:=Copy(TempStrng,i+1,length(TempStrng)-i);
	   Delete(TempStrng,i,length(TempStrng)-i+1);
	   TempStrng:=Concat(TempStrng,InsrtStrng,SaveStrng);
	  END;
   END; 
  IF Length(TempStrng)>53 THEN
   BEGIN
    i:=54;
	REPEAT i:=i-1; UNTIL TempStrng[i] = ' ';
    SaveStrng:=Copy(TempStrng,i+1,Length(TempStrng)-i);
	Delete(TempStrng,i+1,Length(TempStrng)-i);
	WrapFlag:=TRUE;
   END
  ELSE WrapFlag:=FALSE;
  TextFont(0);
  MoveTo(8,20); DrawString(TempStrng);
  IF WrapFlag THEN BEGIN MoveTo(14,35); DrawString(SaveStrng); END;
  TextFont(1);
  MoveTo(5,50); DrawString('Click mouse to continue');
  REPEAT SystemTask; UNTIL Button;
  CloseWindow(SmalWind);
  FillRect(LoclRect,black);
  REPEAT SystemTask; UNTIL NOT Button;
  CopyBits(LoclBMap,Screenbits,LoclRect,LoclRect,srcCopy,NIL);
  FlushEvents(EveryEvent,0);
  END;
END;
{********************************************************************************}
PROCEDURE CleanOutRect;
VAR
  i,j:	    Integer;
  TempRect:	Rect;
BEGIN
  FillRect(CleanRect,DiurnalP);
  i:=1;
  WHILE i<=TransIndx  DO
    BEGIN
	  IF SectRect(CleanRect,TransList[i].square,TempRect) THEN 
        BEGIN
          IF i<TransIndx THEN
            FOR j:=i TO TransIndx-1 DO TransList[j]:=TransList[j+1];
          TransIndx:=TransIndx-1;
        END
      ELSE i:=i+1;
    END;
END;
{********************************************************************************}
PROCEDURE RightCnct;
VAR  
  RightPat:	Pattern;
  TempRect:	Rect;
BEGIN {draw right connector}
  GetIndPattern(RightPat,0,25);
  SetRect(TempRect,WhereX+32,WhereY,WhereX+40,WhereY+32);
  FillRect(TempRect,RightPat);
END;
{********************************************************************************}
PROCEDURE DownCnct;
VAR 
  DownPat:	Pattern;
  TempRect:	Rect;
BEGIN {draw down connector}
  GetIndPattern(DownPat,0,6);
  SetRect(TempRect,WhereX-40,WhereY+32,WhereX-8,WhereY+40);
  FillRect(TempRect,DownPat);
END;
{********************************************************************************}
PROCEDURE PlotWord;
VAR
  CopyMode:    Integer;
  PlotRect:	   Rect;
BEGIN
  SetRect(PlotRect,PlotX,PlotY,PlotX+32,PlotY+32);
  TransIndx:=TransIndx+1;
  TransList[TransIndx].Square:=PlotRect;
  TransList[TransIndx].IconID:=PWord;
  CopyMode:=srcCopy;
  IF PWord<0 THEN
    BEGIN
      PWord:=-PWord;
      CopyMode:=NotSrcCopy;
    END;
  CopyBits(WordIcon[PWord],ScreenBits,StdRect1,PlotRect,CopyMode,NIL);
END;
{********************************************************************************}
PROCEDURE PlotSntc;
VAR
  i,j,PlotX,PlotY,LoclWord,WordIndx,x,y,z,delta,MVerbA:    Integer;
  DealFlag,RevealF,TempFlag,RespFlag:    Boolean;
  TempRect:    Rect;
  MyRect:	   Rect;
  LongX:       LongInt;
  NumString:   Str255;
BEGIN
  MVerbA:=Sentence[Who,VerbA];
  RespFlag:=(MVerbA=WBeg) OR (MVerbA=WThreat);
  IF RespFlag THEN FOR i:=3 TO SntcLeng DO
    BEGIN
	  Sentence[Who,i]:=LastSntc[Who,i];
	  IF Who=Player THEN CanclAble[i]:=FALSE;
	END;
  TempFlag:=(Sentence[Who,VerbB]>=36) AND (Sentence[Who,VerbB]<=38);
  RevealF:=(Abs(MVerbA)=WReveal) AND TempFlag;
  DealFlag:=((MVerbA=WReveal) AND NOT TempFlag) 
  				OR (RespFlag AND (Sentence[Who,VerbB]=WReveal));
  MoveTo(ScrnX2+4,ScrnY2-4);
  FOR j:=1 TO SntcLeng DO
    BEGIN
      LoclWord:=Sentence[Who,j];
      IF DealFlag THEN
        BEGIN {special construction for reveal-deal-sentences}
          IF LoclWord<>0 THEN
            BEGIN
              WordIndx:=j;
              IF j=6 THEN WordIndx:=8;
              IF j>=7 THEN WordIndx:=j+3;
              PlotX:=WhereX+DealPosX[WordIndx];
              PlotY:=WhereY+DealPosY[WordIndx];
              PlotWord(LoclWord,PlotX,PlotY);
              CASE j OF
                SubjectA: RightCnct(PlotX,PlotY);
                VerbA: RightCnct(PlotX,PlotY);
                ObjectA1:
                  BEGIN
                    PlotX:=WhereX+DealPosX[VerbA];
                    PlotY:=WhereY+DealPosY[VerbA];
                    DownCnct(PlotX+40,PlotY);
                  END;
                ObjectA2: DownCnct(PlotX+40,PlotY);
                SubjectB:
                  BEGIN
                    PlotX:=WhereX+DealPosX[6];
                    PlotY:=WhereY+DealPosY[6];
					SetRect(MyRect,1,0,9,32);
					SetRect(TempRect,PlotX-8,PlotY,PlotX,PlotY+32);
					CopyBits(WordIcon[81],ScreenBits,MyRect,TempRect,srcCopy,NIL);
                    PlotWord(WIf,PlotX,PlotY);
                    PlotX:=WhereX+DealPosX[7];
                    PlotY:=WhereY+DealPosY[7];
					SetRect(MyRect,23,0,31,32);
					SetRect(TempRect,PlotX-8,PlotY,PlotX,PlotY+32);
					CopyBits(WordIcon[81],ScreenBits,MyRect,TempRect,srcCopy,NIL);
                    PlotWord(Sentence[Who,ObjectA1],PlotX,PlotY);
                    RightCnct(PlotX,PlotY);
                  END;
                VerbB:
                  BEGIN
                    RightCnct(PlotX,PlotY);
                    PlotX:=WhereX+DealPosX[9];
                    PlotY:=WhereY+DealPosY[9];
                    PlotWord(Sentence[Who,SubjectA],PlotX,PlotY);
                    PlotX:=WhereX+DealPosX[8];
                    PlotY:=WhereY+DealPosY[8];
                    DownCnct(PlotX+40,PlotY);
                  END;
                ObjectB1: DownCnct(PlotX+40,PlotY);
              END; {of CASE statement}
            END;
        END;

      IF RevealF THEN
        BEGIN {Special reveal construction}
          IF LoclWord<>0 THEN
            BEGIN
              CASE j OF
                SubjectA,VerbA:
                  BEGIN
                    PlotX:=WhereX+WordPosX[j];
                    PlotY:=WhereY+WordPosY[j];
                    PlotWord(LoclWord,PlotX,PlotY);
                    RightCnct(PlotX,PlotY);
                  END;
                ObjectA1:
                  BEGIN
                    PlotX:=WhereX+WordPosX[j];
                    PlotY:=WhereY+WordPosY[j];
                    PlotWord(LoclWord,PlotX,PlotY);
                    DownCnct(PlotX,PlotY);
                  END;
                SubjectB:
                  BEGIN
                    PlotX:=WhereX+WordPosX[j-1];
                    PlotY:=WhereY+WordPosY[j-1];
                    PlotWord(LoclWord,PlotX,PlotY);
                    DownCnct(PlotX+40,PlotY);
                  END;
                VerbB:
                  BEGIN
                    PlotX:=WhereX+WordPosX[ObjectA2];
                    PlotY:=WhereY+WordPosY[ObjectA2]+40;
                    PlotWord(LoclWord,PlotX,PlotY);
                    IF Sentence[Who,ObjectB1]>0 THEN DownCnct(PlotX+40,PlotY);
                  END;
                ObjectB1:
                  BEGIN
                    PlotX:=WhereX+WordPosX[ObjectA2];
                    PlotY:=WhereY+WordPosY[ObjectA2]+80;
                    PlotWord(LoclWord,PlotX,PlotY);
                  END;
              END; {of CASE Statement}
            END;
        END;
      IF (NOT DealFlag) AND (NOT RevealF) THEN
        BEGIN {standard construction}
          IF LoclWord<>0 THEN
            BEGIN
              PlotX:=WhereX+WordPosX[j];
              PlotY:=WhereY+WordPosY[j];
              PlotWord(LoclWord,PlotX,PlotY);
              IF (j<ObjectB2) & ((Sentence[Who,j+1]<>0) OR EndConnect) THEN
                BEGIN {draw connector}
                  IF (j mod 4)<>ObjectA1 THEN RightCnct(PlotX,PlotY)
                                         ELSE DownCnct(PlotX,PlotY);
                END;
            END;
        END;
    END;

  {$IFC DebugFlg}
  {ClearRect(ScrnX2+4,ScrnY2-16,512,ScrnY2-4);
  MoveTo(ScrnX2+4,ScrnY2-4);
  MyWrite(LoclWord); DrawString(' ');
  MyWrite(SntcIndx); DrawString(' ');
  FOR j:=1 TO SntcLeng DO
    BEGIN
      MyWrite(Sentence[Who,j]);
      IF CanclAble[j] THEN DrawString('T') ELSE DrawString('F');
      DrawString(' ');
    END;
  LongX:=FreeMem; NumToString(LongX,NumString); DrawString(NumString);}
  {$ENDC}
END;
{********************************************************************************}
PROCEDURE DrawClock;
VAR
  Hours,Minutes,temp:	 Integer;
  PMFlag:		Boolean;
BEGIN
  ClearRect(x-4,y,x+56,y+26);
  MoveTo(x-4,y+10);
  DrawString('Day '); MyWrite(DDate);
  MoveTo(x-4,y+24);
  temp:=DTime;
  Hours:=temp div 60;
  Minutes:=temp mod 60;
  PMFlag:=(Hours>11);
  IF Hours>12 THEN Hours:=Hours-12;
  MyWrite(Hours);
  DrawString(':');
  IF Minutes<10 THEN
    BEGIN DrawString('0'); DrawChar(chr(Minutes+48)); END
  ELSE
    BEGIN
      temp:=Minutes div 10;
      DrawChar(chr(temp+48));
      DrawChar(chr((Minutes-10*temp)+48));
    END;
  DrawString(' ');
  IF PMFlag THEN DrawString('PM') ELSE DrawString('AM');
END;
{************************************************************************}
PROCEDURE GrayRect;
BEGIN
  PenPat(gray);
  PenMode(PatBic);
  PaintRect(ThisRect);
  PenNormal;
END;
{********************************************************************************}
FUNCTION RectHit;
BEGIN
  InvertRect(TestRect);
  REPEAT UNTIL NOT Button;
  InvertRect(TestRect);
  GetMouse(MousePt);
  RectHit:=PtInRect(MousePt,TestRect);
END;
{********************************************************************************}
{FUNCTION NewMyOpen;
VAR
  Error: OSErr;
  MyParmBlk:	ParamBlockRec;
  MyParmBlkPtr:	ParmBlkPtr;
BEGIN
  MyParmBlk.ioCompletion:=NIL;
  MyParmBlk.ioNamePtr:=@FileName;
  MyParmBlk.ioVRefNum:=0;
  MyParmBlk.ioVersNum:=0;
  MyParmBlk.ioPermssn:=3;
  MyParmBlk.ioMisc:=NIL;
  Error:=PBOpen(MyParmBlkPtr,FALSE);
  IF Error<>0 THEN
    BEGIN
	  ClearRect(100,100,512,120);
	  TextFont(0); TextSize(12);
	  MoveTo(102,116); DrawString('Disk Problem');
	  MyWrite(Error); DrawString(FileName);
	  REPEAT UNTIL Button;
	  ExitToShell;
	END;
  NewMyOpen:=MyParmBlk.ioRefNum;
END;}
{********************************************************************************}
{FUNCTION MyOpen;
VAR
  Error: OSErr;
  LocalNum: Integer;
  NameStr:  Str255;
  volName:	StringPtr;
  WDrefNum:	Integer;
  volNamePtr:	StringPtr;
BEGIN
  NameStr:=Concat('Siboot800K:',FileName);
  Error:=FSOpen(NameStr,0,LocalNum);
  IF Error<>0 THEN
    BEGIN
	  NameStr:=Concat('Siboot400KA:',FileName);
	  Error:=FSOpen(NameStr,0,LocalNum);
	  IF Error<>0 THEN
		BEGIN
		  NameStr:=Concat('Siboot400KB:',FileName);
		  Error:=FSOpen(NameStr,0,LocalNum);
		  IF Error<>0 THEN 
		    BEGIN
		      NameStr:=Concat('DataFrame:Siboot_:',FileName);
		      Error:=FSOpen(NameStr,0,LocalNum);
			END;
		  IF Error<>0 THEN
			BEGIN
			  ClearRect(100,100,512,120);
			  TextFont(0); TextSize(12);
			  MoveTo(102,116); DrawString('Disk Problem');
			  MyWrite(Error); DrawString(NameStr);
			  REPEAT UNTIL Button;
			  ExitToShell;
			END;
		END;
	END;
  MyOpen:=LocalNum;
END;}
{********************************************************************************}
PROCEDURE StatDisp;
VAR
  x,y: Integer;
BEGIN
  CleanOutRect(StatRect);
  x:=ScrnX1+84;
  y:=ScrnY1+2;
  DrawClock(x,y,Day,Time);
  
  y:=y+39;
  x:=x-2;
  IF CharLocn[Player]<0 THEN 
    BEGIN {Waiting outside someone's house}
	  x:=x-16;
	  PlotWord(86,x,y);
	  x:=x+32;
	  PlotWord(56-CharLocn[Player],x,y);
	  x:=x-16;
	END;
  IF CharLocn[Player]>0 THEN PlotWord(CharLocn[Player]+56,x,y);
  y:=y+39;
  IF (CharLocn[Player]>0) & (Interloc[Player]>0) THEN PlotWord(Interloc[Player],x,y);
END;
{*************************************************************************}
PROCEDURE MakeAFace;
BEGIN
  IF Him=Player THEN
    BEGIN
	  SavedFace:=WhichFace;
	  CopyBits(Emotion[WhichFace],ScreenBits,StdRect4,FaceRect,srcCopy,NIL);
	  {MoveTo(ScrnX1+2,340); MyWrite(WhichFace);}
	END;
END;
{********************************************************************************}
PROCEDURE MyTranslate;
VAR
  i,CopyMode,x:	    Integer;
  TestRect:	    Rect;
  NegnFlag:	     Boolean;
BEGIN
  IF TransIndx>0 THEN
    BEGIN {test for inclusion in TransList}
      FOR i:=1 TO TransIndx DO
        BEGIN
          TestRect:=TransList[i].Square;
          IF PtInRect(MousePt,TestRect) THEN
            BEGIN
              HideCursor;
              x:=TransList[i].IconID;
              IF x<0 THEN BEGIN NegnFlag:=TRUE; x:=-x; CopyMode:=NotSrcCopy; END
                     ELSE BEGIN NegnFlag:=FALSE; CopyMode:=SrcCopy; END;
              CopyBits(WordText[x],ScreenBits,StdRect1,TestRect,srcCopy,NIL);
              IF NegnFlag THEN
                 CopyBits(WordText[52],ScreenBits,StdRect1,TestRect,SrcOr,NIL);
              REPEAT UNTIL NOT StillDown;
              ShowCursor;
              CopyBits(WordIcon[x],ScreenBits,StdRect1,TestRect,CopyMode,NIL);
            END;
        END; {of i-loop}
    END;
  IF BarGraphFlag THEN 
    BEGIN
	  FOR i:=1 TO 6 DO
	    BEGIN
	  	  IF PtInRect(MousePt,BarGraphRect[i]) THEN
		    BEGIN
			  HideCursor;
			  SetRect(TestRect,BarGraphRect[i].left,BarGraphRect[i].top,ScrnX2-4,BarGraphRect[i].bottom);
			  FillRect(TestRect,white);
			  IF (i mod 2)=1 THEN x:=1 ELSE x:=0;
			  MoveTo(BarGraphRect[i].left,BarGraphRect[i].bottom-x);
			  TextFont(1);
			  TextSize(9);
			  DrawString(BarGraphLabl[i]);
			  TextFont(0);
			  TextSize(12);
			  REPEAT UNTIL NOT StillDown;
			  ShowCursor;
			  FillRect(TestRect,DiurnalP);
			  IF (i mod 2)=1 THEN FillRect(BarGraphRect[i],gray)
			  				 ELSE FillRect(BarGraphRect[i],black);
			  FrameRect(BarGraphRect[i]);
		    END;
		END; {of i-loop}
	  IF PtInRect(MousePt,FaceRect) & (Interloc[Player]>0) THEN
	    BEGIN
		  HideCursor;
		  FillRect(FaceRect,white);
		  MoveTo(FaceRect.left+10,FaceRect.top+35);
		  TextFont(1);
		  TextSize(9);
		  DrawString(CharName[Interloc[Player]]);
		  MoveTo(FaceRect.left+10,FaceRect.top+50);
		  DrawString('looks');
		  MoveTo(FaceRect.left+10,FaceRect.top+65);
		  CASE SavedFace OF
		    1: DrawString('suspicious.');
		    2: DrawString('doubtful.');
		    3: DrawString('angry.');
		    4: DrawString('worried.');
		    5: DrawString('indignant.');
		    6: DrawString('inquisitive.');
		    7: DrawString('hurt.');
		    8: DrawString('flattered.');
		    9: DrawString('surprised.');
		    10: DrawString('smirky.');
		    11: DrawString('self-satisfactied.');
		    12: DrawString('light-hearted.');
		    13: DrawString('sneering.');
		    14: DrawString('apologetic.');
		    15: DrawString('fearful.');
		    16: DrawString('smug.');
		    17: DrawString('sympathetic.');
		    18: DrawString('disappointed.');
		    19: DrawString('accusatory.');
		    20: DrawString('conspiratorial.');
		    21: DrawString('fearful.');
		    22: DrawString('trusting.');
		    23: DrawString('hate-filled.');
		    24: DrawString('distrustful.');
		    25: DrawString('chatty.');
		    26: DrawString('loving.');
		    27: DrawString('forgiving.');
		    28: DrawString('thankful.');
		    29: DrawString('flattering.');
		    30: DrawString('giggly.');
		    31: DrawString('irritated.');
		    32: DrawString('supplicatory.');
		    33: DrawString('uncooperative.');
		    34: DrawString('threatening.');
		  END;
		  TextFont(0);
		  TextSize(12);
		  REPEAT UNTIL NOT StillDown;
		  ShowCursor;
		  MakeAFace(Player,SavedFace);
		END;
	END;
END;
{********************************************************************************}
PROCEDURE WaitForOK;
VAR
  OKFlag: Boolean;
BEGIN
  FillRect(OKRect,white);
  MoveTo(OKRect.left+22,OKRect.top+21); DrawString('OK');
  FrameRect(OKRect);
  OKFlag:=FALSE;
  REPEAT
    SystemTask;
    IF GetNextEvent(everyEvent,myEvent) THEN
      BEGIN
        IF myEvent.what=KeyDown THEN
          BEGIN
            IF BitAnd(myEvent.message,CharCodeMask)=13 THEN
              BEGIN
                InvertRect(OKRect);
                MyWait(10);
                InvertRect(OKRect);
                OKFlag:=TRUE;
              END;
          END;
        IF myEvent.what=mouseDown THEN
          BEGIN
            MousePt:=myEvent.where;
            IF PtInRect(MousePt,OKRect) THEN
              BEGIN
                InvertRect(OKRect);
                REPEAT UNTIL NOT StillDown;
                InvertRect(OKRect);
                OKFlag:=TRUE;
              END;
            MyTranslate;
          END;
      END;
  UNTIL OKFlag;
  FillRect(OKRect,DiurnalP);
  FlushEvents(EveryEvent,0);
  MyEvent.what:=NullEvent;
END;
{********************************************************************************}
END.
